# 可视化报告风格库

> 11种数据报告视觉风格的**参考素材**。前5种来自金融/咨询/媒体传统，后6种借鉴设计界的经典哲学，覆盖从权威专业到温暖诗意的完整光谱。
> 这里提供的是上下文和灵感，不是必须逐字执行的模板。理解每种风格的精神，用你的判断去实现。

## 使用哲学

**Context, not control.** 这些色值、字体、布局规范是经过验证的起点，但AI应该根据具体内容和场景做出自己的判断。一个好的FT风格报告不需要完全复制这里的每个CSS属性，而是要捕捉到「三文鱼粉的温暖权威感」这个精神。

## 使用方式

1. 用户指定风格 → 参考对应风格的精神和色彩方向
2. 用户未指定 → 随机选择一种，简短告知用户
3. 选择后在回复开头简短说明所用风格（如「本次使用 Financial Times 风格」）

## 所有风格共享的基础布局

**无论哪种风格，以下是工程底线**：

```css
html { background: [与body背景色一致]; }
body {
  max-width: 1200px;
  margin: 0 auto;        /* 水平居中 */
  padding: 40px 48px;    /* 内容呼吸空间 */
}
```

- 报告必须在浏览器中居中显示
- html和body背景色一致，居中后两侧无色差
- 无CDN依赖（Playwright离线截图会白屏）
- SVG viewBox完整，标注不越界

---

## 风格 1：Financial Times（三文鱼粉）

> 一句话：「我们不需要花哨的视觉来证明自己的价值，信息本身就是价值。」

### 色彩

| 用途 | 色值 | 说明 |
|------|------|------|
| 页面背景 | `#FFF1E5` | FT标志性三文鱼粉 |
| 卡片/内容区 | `#FFFFFF` | 纯白，与粉色背景柔和对比 |
| 主要文字 | `#33302E` | 深棕灰，非纯黑 |
| 次要文字 | `#6B6B6B` | 中灰色，标注/来源/元信息 |
| 强调蓝 | `#0F5499` | FT品牌蓝，链接/标签/重点数据 |
| 警告红 | `#CC0000` | 负面数据、风险提示 |
| 正向绿 | `#09823A` | 正面数据、增长指标 |
| 边框 | `#E0D3C3` | 暖色调细边框 |
| 图表辅助 | `#996600` | 金棕色，第三数据系列 |

### 字体

| 场景 | 字体 |
|------|------|
| 标题/章节名 | `Georgia, 'Times New Roman', serif` |
| 正文/数据 | `-apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif` |
| 数字 | `font-variant-numeric: tabular-nums` |

### 关键设计元素

- **4px蓝色顶线**（`#0F5499`）：页面最顶部，FT最标志性的视觉元素
- **边框**：1px实线 `#E0D3C3`，不用box-shadow，不用粗线
- **圆角**：无或极小（最多4px）
- **间距**：大量留白。Section间距48px，段落16px，卡片内边距24px
- **分隔线**：40px短线或全宽1px细线
- **衬线标题 + 无衬线正文**：传递传统金融媒体的权威感
- **数据内嵌叙事**：关键数字嵌入文字段落，不孤立在图表里

### ECharts配置

- 关闭动画（`animation: false`）
- 线条宽度2px
- 网格线虚线 `#F5EDE3`
- 图例矩形小方块（`icon: 'rect'`），12px
- 图表下方必须有source line，11px灰色字
- Tooltip白色背景 + 细边框，不用阴影

---

## 风格 2：McKinsey Consulting（深蓝权威）

> 一句话：每个图表都是「证据」，每个标题都是「结论」。

### 色彩

| 用途 | 色值 |
|------|------|
| 页面背景 | `#FFFFFF` |
| Header | `#003366`（McKinsey深蓝） |
| 主文字 | `#1A1A2E` |
| 次文字 | `#666680` |
| 强调蓝 | `#4472C4` |
| 强调橙 | `#ED7D31`（警告/风险） |
| 强调绿 | `#70AD47`（正向） |
| 弱化填充 | `#A5B4C8` |
| 边框 | `#D6D6D6` |
| 斑马纹行 | `#F7F8FA` |
| Takeaway框 | `#F4F6F9` |

### 字体

全部使用 `'Helvetica Neue', Arial, sans-serif`

### 关键设计元素

- **Exhibit编号**：图表标注为「Exhibit 1:」「Exhibit 2:」，不是「图1」
- **结论式标题**：标题是结论不是描述（如「Cloud revenue drives 60% of incremental growth」而非「Revenue by segment」）
- **Key Takeaway框**：4px左边框 `#003366`，浅灰背景 `#F4F6F9`，「KEY TAKEAWAY」大写标签
- **KPI Strip**：紧贴Header下方，同色深蓝背景，5个指标并排
- **Source Line**：每个Exhibit必须有来源标注
- **无渐变、无阴影、无圆角**

### 页面结构

```
[深蓝Header: 标题 + 副标题 + Confidential]
[深蓝KPI Strip: 5个指标并排]
[白色内容区]
  Exhibit 1: [结论式标题]
    [图表]
    [Source Line]
    [Key Takeaway框]
  ─────────────
  Exhibit 2: ...
[深蓝结论框]
[Footer: Disclaimer]
```

### ECharts色板

```javascript
['#003366', '#4472C4', '#70AD47', '#ED7D31', '#A5B4C8']
```

---

## 风格 3：The Economist（杂志红线）

> 一句话：红色是信号不是装饰，每个图表标题都带观点和态度。

### 色彩

| 用途 | 色值 |
|------|------|
| 页面背景 | `#FFFFFF` |
| Header标识线 | `#E3120B`（6px红线） |
| 主文字 | `#1D1D1B` |
| 次文字 | `#616161` |
| 强调红 | `#E3120B`（图表主线、KPI强调） |
| 辅助蓝绿 | `#0A5E87` |
| 正向绿 | `#3B7A57` |
| 边框 | `#DBDBDB` |
| 浅背景 | `#F5F5F5` / `#FAFAFA` |

### 字体

| 场景 | 字体 |
|------|------|
| 标题 | `Georgia, 'Times New Roman', serif` |
| 正文 | `'Helvetica Neue', Arial, sans-serif` |

### 关键设计元素

- **6px红色顶线**：页面和KPI区顶部
- **3px红色细线**：每个图表区块顶部，The Economist图表的视觉签名
- **Editorial标题**：图表标题带观点（「AI的胃口」而非「资本开支趋势」）
- **副标题**：通俗语言解释图表内容
- **Pull Quote**：大号衬线字体 + 左侧红色竖线
- **信息密度高如杂志**：双栏布局优先，图表紧凑（260-280px高度）
- **Small Multiples**：多个小图表优于一个巨型图表

### 红色使用原则

- 每个section最多一个红色元素作为焦点
- 用于顶线、图表thin bar、最重要数据线、关键数字强调、Pull quote竖线
- **不滥用**：作为焦点而非填充

### ECharts色板

```javascript
['#E3120B', '#0A5E87', '#3B7A57', '#B8B8B8']
```

---

## 风格 4：Goldman Sachs（投行报告）

> 一句话：Tables are king — 数据表格承载分析，图表只是辅助。

### 色彩

| 用途 | 色值 |
|------|------|
| 页面背景 | `#F8F9FA` |
| 卡片/表格 | `#FFFFFF` |
| Header | `#00338D`（GS深蓝） |
| 主文字 | `#1B1B1B` |
| 次文字 | `#5F6368` |
| 强调金 | `#D4AF37`（投资论点、Base Case） |
| 负面红 | `#C62828` |
| 正向绿 | `#2E7D32` |
| 边框 | `#DEE2E6` |
| 斑马纹行 | `#FAFBFC` |
| Bottom Line | `#F0F4F8` |

### 字体

全部使用 `'Helvetica Neue', Arial, sans-serif`
- 表头：11px, 600, 白色, 大写, 0.5px letter-spacing
- 行标签：11px, 500, 灰色, 大写, 0.3px spacing
- 数据：12px, 400

### 关键设计元素

- **Rating Strip**：BUY(绿)/NEUTRAL(金)/SELL(红) 评级徽章，报告顶部最先看到
- **Investment Thesis框**：白色卡片 + 4px金色左边框 `#D4AF37`
- **密集金融表格**：深蓝表头、斑马纹、hover态、关键值高亮
- **Bottom Line Strip**：浅灰蓝背景 + 3px深蓝左边框，一句话总结
- **DCF Sensitivity Table**：Base Case用金色边框高亮，高于/低于现价分别用绿/红
- **Risk Badges**：HIGH(红边框), MED(金边框), LOW(绿边框)
- **无渐变、无阴影、无圆角**：锐利边缘传递机构权威感

### GS设计原则

1. Tables are king — 数据表格承载分析
2. Navy + Gold 双色签名 — 深蓝是结构，金色是强调
3. Bottom line clarity — 每个section都以一句话结论收尾
4. Dense but scannable — 数据密集但层级清晰
5. Rating-first — 评级判断最先呈现

### ECharts色板

```javascript
['#00338D', '#5B9BD5', '#A5A5A5', '#C62828']
```

---

## 风格 5：Swiss / NZZ Minimal（瑞士极简）

> 一句话：只用黑白灰红四种色彩、Helvetica一种字体、极端字号对比和大量留白，让数据自己说话。

### 色彩

| 用途 | 色值 |
|------|------|
| 页面背景 | `#FFFFFF`（纯白，不接受其他底色） |
| 主文字 | `#000000` |
| 次文字 | `#767676` |
| 强调红 | `#FF0000`（Swiss Red，极度克制使用） |
| 边框主 | `#000000`（1px黑线） |
| 边框次 | `#E5E5E5` |

### 色彩使用原则

- 红色是「信号」不是「装饰」— 每个section最多一个红色元素
- 整页红色元素不超过3-5个
- 图表用 黑+深灰+中灰，仅一个系列用红色强调
- 永远不使用渐变、阴影、发光效果

### 字体

全部使用 `'Helvetica Neue', Helvetica, Arial, sans-serif`

| 层级 | 字号 | 字重 |
|------|------|------|
| Display | 72px | 900 (Black) |
| Section Title | 48px | 900 (Black) |
| Key Number | 36-64px | 700-900 |
| Subtitle | 24px | 300 (Light) |
| Body | 16px | 400 (Regular) |
| Label | 13-14px | 400 |

- 标题与正文字号比至少 4:1
- 大字号 letter-spacing 负值（-1px 到 -4px），小字号正值（0.5px-2px）

### 关键设计元素

- **极端字号对比**：72px标题 vs 13px标签
- **黑色分隔线**：`1px solid #000000`，章节间的唯一分隔手段
- **严格网格**：5列等分指标条，4列护城河，3列判断区间
- **Grid列间分隔**：`border-right: 1px solid #E5E5E5`
- **大量留白**：页面内边距60-80px，Section间距60-64px

### 绝对禁止

圆角、阴影、渐变、背景色块（除纯白）、图标/Emoji、装饰性元素、动画

### ECharts色板

```javascript
['#000000', '#444444', '#999999', '#FF0000']
```

---

---

## 风格 6：Stamen Design（数据诗学）

> 一句话：「数据不是冷冰冰的表格，是可以触摸的地形。」

灵感来自Stamen Design——以地图学思维做数据可视化的工作室。他们的COVID-19 surge map和城市数据作品证明了：数据可以像风景一样温暖、有机、分层。

### 色彩

| 用途 | 色值 | 说明 |
|------|------|------|
| 页面背景 | `#FAF6F1` | 羊皮纸般的暖奶白 |
| 卡片/内容区 | `#FFFFFF` | 纯白浮于暖底之上 |
| 主要文字 | `#2D2A26` | 深棕，非纯黑 |
| 次要文字 | `#8C7E72` | 赭石灰，温暖的辅助色 |
| 赭石主色 | `#C07850` | 数据系列主色，泥土般温暖 |
| 鼠尾草绿 | `#7A9E7E` | 正向数据、增长 |
| 深海蓝 | `#2E5266` | 第三数据系列、深层信息 |
| 沙金 | `#D4A76A` | 高亮、警示 |
| 边框 | `#E5DDD4` | 暖色调边界 |
| 浅填充 | `#F0EBE4` | 区块背景、斑马纹 |

### 字体

| 场景 | 字体 |
|------|------|
| 标题 | `Georgia, 'Palatino Linotype', serif` |
| 正文/数据 | `-apple-system, 'Segoe UI', sans-serif` |
| 数字 | `font-variant-numeric: tabular-nums` |

### 关键设计元素

- **地形层叠感**：用2-3层微妙的背景色差区分信息层级（`#FAF6F1` → `#FFFFFF` → `#F0EBE4`）
- **有机圆角**：圆角12-16px，远离锐利的机构感
- **温柔阴影**：`box-shadow: 0 2px 12px rgba(45,42,38,0.06)`，像纸张微微翘起
- **手工感标注**：图表数据点的标注用斜体衬线字体，像手写备注
- **数据叙事**：图表配长段落文字解读，叙事和可视化交织（非先图后文的割裂结构）
- **地图色阶**：连续数据用从浅赭石到深海蓝的渐变色阶，像等高线地图
- **无硬线分隔**：用留白和背景色差替代分隔线

### ECharts配置

- 系列色板：`['#C07850', '#2E5266', '#7A9E7E', '#D4A76A', '#8C7E72']`
- 网格线：`#E5DDD4`，虚线
- 坐标轴线：`#C0B5A8`
- Tooltip：白色背景 + 8px圆角 + 轻阴影

---

## 风格 7：Fathom（科学叙事）

> 一句话：「每一个像素都必须承载信息——科学期刊的严谨，设计杂志的优雅。」

灵感来自Fathom Information Design——为盖茨基金会、Nature做数据可视化的团队。他们的作品证明了：学术严谨不等于枯燥。

### 色彩

| 用途 | 色值 | 说明 |
|------|------|------|
| 页面背景 | `#F7F8FA` | 冷调浅灰，实验室的干净 |
| 卡片/内容区 | `#FFFFFF` | 纯白 |
| 主要文字 | `#1A1F36` | 海军蓝黑 |
| 次要文字 | `#6E7891` | 冷灰蓝 |
| 海军蓝 | `#1B3A5C` | 图表主色、章节标识 |
| 石板蓝 | `#5B7FA5` | 第二数据系列 |
| 信号橙 | `#E8724A` | 异常值高亮、唯一暖色 |
| 中性灰 | `#B0BAC9` | 参考线、弱化数据 |
| 边框 | `#DDE1E9` | 冷色调细边框 |
| 注脚背景 | `#EEF0F5` | 注释/来源区域 |

### 字体

全部使用 `-apple-system, 'Inter', 'Segoe UI', sans-serif`
- 标题：500字重，不加粗到700（克制的强调）
- 正文：400，16px
- 注脚/来源：13px，斜体

### 关键设计元素

- **注释系统**：关键数据点用上标数字标注（如 ²³⁴），页面底部有脚注区域，浅灰背景 `#EEF0F5`
- **图表标题双层结构**：主标题（结论）+ 副标题（数据说明），两行不同字重
- **精确的坐标轴**：刻度线外伸4px，轴标签精确到必要小数位，不多不少
- **信号橙只用于异常**：整份报告中信号橙 `#E8724A` 只出现在真正需要注意的地方
- **方法论区块**：浅灰底色卡片，说明数据来源和计算方法，增加可信度
- **无装饰**：无圆角（最多2px），无阴影，1px实线边框
- **Figure编号**：图表标注为「Figure 1.」「Figure 2.」，学术范
- **紧凑间距**：Section间距32px（比FT/Swiss更紧），信息密度高但呼吸感靠白底维持

### ECharts配置

```javascript
['#1B3A5C', '#5B7FA5', '#B0BAC9', '#E8724A']
```
- 线条宽度1.5px（比一般报告细，更精确的感觉）
- 数据点半径3px，hover态5px
- 网格线`#EAEDF2`，实线（不是虚线，学术风格）

---

## 风格 8：Sagmeister & Walsh（快乐极简）

> 一句话：「99%的克制 + 1%的意外色彩爆发 = 让人微笑的数据报告。」

灵感来自Sagmeister & Walsh——证明了「美即功能的情感维度」的设计二人组。他们的Happy Show展览将情感量化，这正是数据报告可以借鉴的：数据不只传达信息，也可以传达情感。

### 色彩

| 用途 | 色值 | 说明 |
|------|------|------|
| 页面背景 | `#FAFAFA` | 接近纯白的暖灰 |
| 卡片/内容区 | `#FFFFFF` | 纯白 |
| 主要文字 | `#1A1A1A` | 近黑 |
| 次要文字 | `#757575` | 中灰 |
| 珊瑚粉 | `#FF6B6B` | 色彩爆发主角（每section限1处） |
| 活力黄 | `#FFD93D` | 高亮、KPI背景 |
| 薄荷青 | `#6BCB77` | 正向数据 |
| 电子蓝 | `#4D96FF` | 链接、图表辅助 |
| 边框 | `#E8E8E8` | 极淡灰 |

### 字体

全部使用 `-apple-system, 'Helvetica Neue', sans-serif`
- 关键数字：48-64px，800字重，配色彩（这是「爆发」的一种方式）
- 标题：24px，700
- 正文：15px，400

### 关键设计元素

- **色彩爆发规则**：整份报告90%是黑白灰，每个section允许一次「色彩爆发」——一个大号彩色数字、一个彩色卡片背景、或一个彩色图表柱。像白墙上的一幅画。
- **超大关键数字**：报告中最重要的3-5个数字用48-64px呈现，配珊瑚粉或活力黄底色
- **圆角卡片**：16px圆角，轻阴影（`0 4px 20px rgba(0,0,0,0.06)`），友好而非严肃
- **手工感元素**：偶尔用波浪下划线（CSS wavy underline）替代直线，增加温暖
- **正能量语言**：标题用积极句式（「增长超预期」而非「未达历史水平」）
- **KPI卡片**：白底+单色大字+底部细线色条（4px高度的彩色条）
- **无衬线全场**：全程sans-serif，靠字号和色彩而非字体种类制造层级

### ECharts配置

```javascript
['#FF6B6B', '#4D96FF', '#6BCB77', '#FFD93D', '#757575']
```
- 圆角柱状图（`barBorderRadius: [8, 8, 0, 0]`）
- 线条宽度3px（略粗，更友好）
- Tooltip圆角12px + 彩色左边框

---

## 风格 9：Takram（日式思辨）

> 一句话：「技术是思考的媒介——温柔地展示数据，像在引导一场安静的对话。」

灵感来自Takram——东京的设计工程团队。他们为NHK等客户制作的数据可视化证明了：科技感不需要冰冷，可以像一杯温水一样柔和。

### 色彩

| 用途 | 色值 | 说明 |
|------|------|------|
| 页面背景 | `#F5F2ED` | 温暖亚麻色，像日式纸张 |
| 卡片/内容区 | `#FEFDFB` | 极暖白 |
| 主要文字 | `#2C2C2C` | 深灰，非纯黑 |
| 次要文字 | `#8A8580` | 暖灰 |
| 柔蓝 | `#6B8CAE` | 数据主色，沉静不张扬 |
| 草绿 | `#7FA87F` | 正向数据 |
| 赤茶 | `#C47D5A` | 警示/异常，像焙茶色 |
| 藤灰 | `#A8A0A0` | 弱化数据、网格线 |
| 边框 | `#E3DED7` | 暖灰边界 |
| 卡片阴影 | `rgba(44,44,44,0.04)` | 极轻柔阴影 |

### 字体

| 场景 | 字体 |
|------|------|
| 标题 | `'Helvetica Neue', sans-serif`，300字重（轻量感） |
| 正文 | `-apple-system, sans-serif`，400 |
| 标签/注释 | 13px，300字重 |

### 关键设计元素

- **轻量标题**：标题用300字重（Light），不是粗黑体。信息层级靠字号差+留白而非加粗
- **柔和圆角**：16-20px圆角，配极轻阴影，像UI组件浮在纸面上
- **图表即艺术**：图表无外框，坐标轴用细灰线，数据线/柱用柔和色彩，整体像一幅插画
- **呼吸式留白**：Section间距56-64px，卡片内边距32px，不拥挤
- **谦逊的标注**：数据标注小而淡（12px，300字重，灰色），不抢数据本身的注意力
- **渐变色阶**：连续数据用同色系的5级明度渐变（如柔蓝从20%到100%透明度）
- **无分隔线**：完全不用分隔线，只用留白和背景色微差区分区块
- **底部思考区**：报告末尾用虚线边框卡片放「延伸思考」或「待验证假设」，体现思辨精神

### ECharts配置

```javascript
['#6B8CAE', '#7FA87F', '#C47D5A', '#A8A0A0', '#D4C5B0']
```
- 线条宽度2px
- 坐标轴线`#D5D0C8`，不显示刻度线（`axisTick: { show: false }`）
- 网格线`#EDEBE7`，虚线
- 柱状图无边框，圆角`[6, 6, 0, 0]`

---

## 风格 10：Irma Boom（编辑叙事）

> 一句话：「打破常规网格，用意外的色彩搭配和非线性布局，让报告像一本值得翻完的书。」

灵感来自Irma Boom——被称为「书籍建筑师」的荷兰设计师。她的SHV Think Book（2136页）证明了：信息密集不等于无趣，意外的色彩组合和边缘游戏能让读者一直往下看。

### 色彩

| 用途 | 色值 | 说明 |
|------|------|------|
| 页面背景 | `#F9F5F0` | 纸张白，微暖 |
| 卡片/内容区 | `#FFFFFF` | 纯白 |
| 主要文字 | `#1E1E1E` | 近黑 |
| 次要文字 | `#7A6E65` | 棕灰 |
| 铁锈红 | `#C75B3A` | 主强调色，温暖而有冲击力 |
| 暮粉 | `#D4898F` | 第二数据系列，与铁锈红出乎意料地协调 |
| 橄榄棕 | `#8B7355` | 第三系列、标签、分隔 |
| 深茶色 | `#4A3728` | 深色区块背景（反白文字） |
| 边框 | `#D9D0C7` | 暖灰边界 |
| 浅填充 | `#F0ECE6` | 区块背景 |

### 字体

| 场景 | 字体 |
|------|------|
| Display标题 | `Georgia, serif`，斜体（Editorial的核心姿态） |
| 章节标题 | `'Helvetica Neue', sans-serif`，700 |
| 正文 | `-apple-system, sans-serif`，400 |

### 关键设计元素

- **意外配色**：铁锈红+暮粉+橄榄棕——这组合在传统报告中不会出现，但放在一起有独特的温暖张力
- **斜体Display标题**：报告大标题用衬线斜体，像杂志Editorial的开篇，传递「这是作者的观点」
- **非对称布局**：偶尔用60/40或70/30分栏替代均匀双栏，打破对称的无聊感
- **深色区块反转**：每份报告中1-2个section用深茶色 `#4A3728` 做背景+白色文字，形成节奏变化
- **边缘游戏**：图表或引用块偶尔延伸到卡片边缘外（负margin），打破网格的规矩感
- **密集但可探索**：信息密度高（like Irma Boom的书），但用色彩和空间变化引导视线
- **Pull Quote大字**：关键结论用36-48px衬线斜体呈现，左侧铁锈红竖线

### ECharts配置

```javascript
['#C75B3A', '#D4898F', '#8B7355', '#4A3728', '#D9D0C7']
```
- 坐标轴线`#C0B5A8`
- 网格线`#E8E0D8`，实线
- 柱状图无圆角（保持编辑锐利感）

---

## 风格 11：Build（奢侈极简）

> 一句话：「70%留白 + 微妙的字重呼吸 = 数据报告也可以有奢侈品的气质。」

灵感来自Build——伦敦的极简品牌工作室。他们证明了：精致的简单比复杂更难。这种风格适合品牌报告、董事会汇报等需要传达「高端感」的场合。

### 色彩

| 用途 | 色值 | 说明 |
|------|------|------|
| 页面背景 | `#FAFAF8` | 极浅暖白 |
| 卡片/内容区 | `#FFFFFF` | 纯白 |
| 主要文字 | `#1C1C1C` | 近黑 |
| 次要文字 | `#999999` | 中灰，大量使用 |
| 强调色 | `#2D5F4A` | 深松绿，唯一品牌色 |
| 浅强调 | `#E8F0EC` | 松绿的10%版本，KPI背景 |
| 弱化灰 | `#CCCCCC` | 边框、网格线、分隔 |
| 数据灰 | `#666666` | 次要数据系列 |

### 字体

全部使用 `'Helvetica Neue', Helvetica, sans-serif`

| 层级 | 字号 | 字重 |
|------|------|------|
| Display | 56px | 200 (Ultralight) |
| Section Title | 32px | 300 (Light) |
| Key Number | 48px | 200 → 配深松绿色 |
| Subtitle | 18px | 400 |
| Body | 15px | 400 |
| Label | 12px | 300，大写，1.5px letter-spacing |

### 关键设计元素

- **超轻字重**：标题和关键数字用200-300字重，区别于大多数报告的700粗黑体。轻盈 = 高端
- **单色强调**：整份报告只用一个强调色——深松绿 `#2D5F4A`。所有需要「强调」的地方都用这一个色
- **70%留白**：内容区面积不超过页面30%。Section间距80px，卡片内边距40px
- **微妙阴影**：`box-shadow: 0 1px 4px rgba(0,0,0,0.04)`，几乎看不见但创造层次
- **大写标签**：所有标签（来源、分类、状态）用12px大写+1.5px字间距，像奢侈品牌的标签
- **呼吸节奏**：标题与正文之间、Section之间用大量留白替代分隔线
- **Golden Ratio**：关键卡片宽高比接近1.618
- **极简图表**：图表只保留数据线/柱+必要标签，去掉坐标轴线、网格线、图例框

### ECharts配置

```javascript
['#2D5F4A', '#666666', '#CCCCCC', '#999999']
```
- 关闭网格线（`splitLine: { show: false }`）
- 关闭坐标轴线（`axisLine: { show: false }`）
- 只保留刻度标签
- 线条宽度1.5px
- 数据标签14px，300字重

---

## 风格速查对比

### 经典五种（金融/咨询/媒体传统）

| 维度 | FT | McKinsey | Economist | Goldman Sachs | Swiss/NZZ |
|------|-----|----------|-----------|---------------|-----------|
| 背景色 | 三文鱼粉 | 纯白 | 纯白 | 浅灰 | 纯白 |
| 品牌色 | 蓝 #0F5499 | 深蓝 #003366 | 红 #E3120B | 深蓝+金 | 红 #FF0000 |
| 标题字体 | 衬线(Georgia) | 无衬线(Helvetica) | 衬线(Georgia) | 无衬线(Helvetica) | 无衬线(Helvetica) |
| 装饰度 | 极简 | 结构化 | 杂志感 | 机构感 | 极度克制 |
| 信息密度 | 中等 | 中高 | 高 | 高 | 中等 |
| 最适场景 | 金融分析、叙事报告 | 战略分析、框架评估 | 行业洞察、观点报告 | 财务建模、估值报告 | 数据展示、设计感报告 |
| 标志元素 | 4px蓝色顶线 | Exhibit编号+结论标题 | 3px红色thin bar | Rating徽章+金色边框 | 72px黑色大字 |

### 设计六种（设计哲学跨界）

| 维度 | Stamen | Fathom | Sagmeister | Takram | Irma Boom | Build |
|------|--------|--------|------------|--------|-----------|-------|
| 背景色 | 暖奶白 #FAF6F1 | 冷浅灰 #F7F8FA | 暖灰 #FAFAFA | 亚麻 #F5F2ED | 纸张白 #F9F5F0 | 极浅暖白 #FAFAF8 |
| 主色调 | 赭石+鼠尾草绿 | 海军蓝+信号橙 | 珊瑚粉+活力黄 | 柔蓝+草绿 | 铁锈红+暮粉 | 深松绿单色 |
| 标题字体 | 衬线(Georgia) | 无衬线(Inter) | 无衬线(Helvetica) | 无衬线轻体 | 衬线斜体 | 无衬线超轻体 |
| 装饰度 | 有机温暖 | 学术精确 | 克制+色彩爆发 | 柔和科技 | 编辑叙事 | 奢侈留白 |
| 信息密度 | 中等 | 高 | 中等 | 中低 | 高 | 低 |
| 最适场景 | 环境/社会/地理数据 | 科研报告、技术分析 | 用户报告、增长复盘 | 产品分析、创新报告 | 年度报告、深度研究 | 品牌报告、董事会汇报 |
| 标志元素 | 地形层叠感+有机圆角 | Figure编号+注脚系统 | 色彩爆发+超大数字 | 轻量标题+柔和阴影 | 斜体大标题+深色反转 | 200字重+70%留白 |
